! Copyright (C) 2019 C. Malica
! This file is distributed under the terms of the
! GNU General Public License. See the file `License'
! in the root directory of the present distribution,
! or http://www.gnu.org/copyleft/gpl.txt .
!
!---------------------------------------------------------------------
SUBROUTINE check_el_cons_qha()
  !-----------------------------------------------------------------------
  !
  !  This routine tries to read the temperature dependent elastic constants 
  !  from the files obtained with the option 'elastic_constants_geo' with the
  !  option use_free_energy for all the geometries generated by the option
  !  what='mur_lc_t'. 
  !  If it finds one geometry it sets el_cons_qha_available to true.
  !  If it finds all geometries it sets also el_cons_qha_t_available to
  !  true.
  !  In the variables el_cons_t and el_comp_t and b0_t it sets
  !  the elastic properties of the central geometry if available or of
  !  the last geometry read if not available.
  !  Similarly for the quantities obtained from direct BZ integration
  !  el_consf_t, el_compf_t, and b0f_t.
  !
  USE kinds,             ONLY : DP
  USE io_global,         ONLY : stdout
  USE cell_base,         ONLY : ibrav
  USE temperature,       ONLY : ntemp, temp
  USE elastic_constants, ONLY : read_el_cons_from_file
  USE thermo_sym,        ONLY : laue
  USE anharmonic,        ONLY : el_cons_t, el_comp_t, b0_ec_t, el_con_geo_t
  USE ph_freq_anharmonic,ONLY : el_consf_t, el_compf_t, b0f_ec_t, el_conf_geo_t
  USE control_elastic_constants, ONLY : el_cons_qha_available,     &
                                        el_consf_qha_available,    &
                                        el_cons_qha_geo_available, &
                                        el_consf_qha_geo_available, &
                                        found_dos_ec, found_ph_ec,  &
                                        fndos_ec, fnph_ec, f_geoph_ec, &
                                        f_geodos_ec
  USE control_thermo,    ONLY : ltherm_dos, ltherm_freq 
  USE data_files,        ONLY : flanhar 
  USE thermo_mod,        ONLY : tot_ngeo, no_ph
  !
  IMPLICIT NONE
  CHARACTER(LEN=256) :: filelastic, filelastic_ph 
  INTEGER :: igeo, central_geo
  !
  LOGICAL  :: check_file_exists
  LOGICAL  :: exst
  !
  el_cons_qha_available=.FALSE.
  el_consf_qha_available=.FALSE.
  found_dos_ec=.FALSE.  
  found_ph_ec=.FALSE.  

  IF (ltherm_dos) THEN
     el_con_geo_t=0.0_DP
     DO igeo = 1, tot_ngeo
        CALL add_geometry_number('anhar_files/', TRIM(flanhar)//'.el_cons', &
                                filelastic, igeo)
        exst=check_file_exists(filelastic)
        IF (.NOT.exst) CYCLE
        !
        !The loop on temperatures is inside read_el_cons_from_file
        !
        CALL read_el_cons_from_file(temp, ntemp, ibrav, laue, &
                  el_con_geo_t(:,:,:,igeo), b0_ec_t(:), filelastic)

        CALL read_dyde(igeo)
        found_dos_ec(igeo)=.TRUE.
        el_cons_t(:,:,:)=el_con_geo_t(:,:,:,igeo)

        WRITE(stdout,'(/,5x,"Geometry number",i5," of elastic constants &
                   &computed via ltherm_dos found")') igeo
        
        el_cons_qha_available=.TRUE.
     END DO
  END IF

  IF (ltherm_freq) THEN
     el_conf_geo_t=0.0_DP
     DO igeo=1, tot_ngeo
        CALL add_geometry_number('anhar_files/', TRIM(flanhar)//'.el_cons', &
                                filelastic_ph, igeo)
        filelastic_ph=TRIM(filelastic_ph)//'_ph'
        exst=check_file_exists(filelastic_ph)
        IF (.NOT.exst) CYCLE
        !
        ! The loop on temperatures is inside read_el_cons_from_file
        !
        CALL read_el_cons_from_file(temp, ntemp, ibrav, laue, & 
                el_conf_geo_t(:,:,:,igeo), b0f_ec_t(:), filelastic_ph)
      
!        CALL read_dyde()
        found_ph_ec(igeo)=.TRUE.
        el_consf_t(:,:,:)=el_conf_geo_t(:,:,:,igeo)

        WRITE(stdout,'(/,5x,"Geometry number",i5," of elastic constants &
                   &computed via ltherm_freq found")') igeo
    
        el_consf_qha_available=.TRUE.
     END DO 
  END IF
 
  IF ((.NOT.el_cons_qha_available).AND.(.NOT.el_consf_qha_available)) RETURN
!
!  If there are the elastic constants of the central geometry we
!  set the el_cons_t, el_comp_t, and b0_t of that geometry. Otherwise
!  they are those of the last geometry read.
!
  CALL find_central_geo(tot_ngeo,no_ph,central_geo)
  WRITE(stdout,'(/,5x,"Central geometry is number",i5)') central_geo

  IF (ltherm_dos) THEN
     IF (found_dos_ec(central_geo)) el_cons_t(:,:,:)=&
                                    el_con_geo_t(:,:,:,central_geo)
     CALL compute_el_comp_t(el_cons_t,el_comp_t, b0_ec_t)
  ENDIF

  IF (ltherm_freq) THEN
     IF (found_ph_ec(central_geo)) el_consf_t(:,:,:)= &
                                    el_conf_geo_t(:,:,:,central_geo)
     CALL compute_el_comp_t(el_consf_t,el_compf_t, b0f_ec_t)
  ENDIF
!
!  If the code arrives here we check if we have the temperature
!  dependent elastic constants for a sufficient number of geometries 
!  and set the relative flag so that the following routines can 
!  do the interpolation.
! 
  fndos_ec=0
  fnph_ec=0
  f_geodos_ec=0
  f_geoph_ec=0
  DO igeo=1, tot_ngeo
     IF (found_dos_ec(igeo)) THEN
        fndos_ec=fndos_ec+1
        IF (f_geodos_ec==0) f_geodos_ec=igeo
     ENDIF
     IF (found_ph_ec(igeo)) THEN
        fnph_ec=fnph_ec+1
        IF (f_geoph_ec==0) f_geoph_ec=igeo
     ENDIF
  ENDDO
  el_cons_qha_geo_available=(fndos_ec>2)
  el_consf_qha_geo_available=(fnph_ec>2)
!  DO igeo=1,tot_ngeo
!     el_cons_qha_geo_available=el_cons_qha_geo_available.AND.found_dos_ec(igeo)
!     el_consf_qha_geo_available=el_consf_qha_geo_available.AND.found_ph_ec(igeo)
!  ENDDO
!
  RETURN
END SUBROUTINE check_el_cons_qha
