#
# Temperature T in K, 
# Chemical potential in Ry
# Energy and free energy in Ry/cell,
# Entropy in Ry/cell/K,
# Heat capacity Cv in Ry/cell/K.
# Multiply by 13.6058 to have energies in eV/cell etc..
# Multiply by 13.6058 x 23060.35 = 313 754.5 to have energies in cal/(N mol).
# Multiply by 13.6058 x 96526.0 = 1 313 313 to have energies in J/(N mol).
# N is the number of formula units per cell.
# For instance in silicon N=2. Divide by N to have energies in cal/mol etc. 
#        T             energy            free energy           entropy              Cv            chemical pot
  0.10000000E+01  0.000000000000E+00 -0.773078601135E-09  0.773078627607E-09  0.773250262525E-09  0.624153997107E+00
  0.40000000E+01 -0.789078802299E-10 -0.124483655606E-07  0.309236442297E-08  0.309235800165E-08  0.624154000493E+00
  0.70000000E+01  0.889677698179E-08 -0.289845984991E-07  0.541162506911E-08  0.541158757370E-08  0.624154010652E+00
  0.10000000E+02  0.272509580457E-07 -0.500576859963E-07  0.773086440761E-08  0.773075526274E-08  0.624154027582E+00
  0.13000000E+02  0.549970528008E-07 -0.756539046964E-07  0.100500736527E-07  0.100498347288E-07  0.624154051285E+00
  0.16000000E+02  0.921522181896E-07 -0.105755683877E-06  0.123692438806E-07  0.123687993690E-07  0.624154081761E+00
  0.19000000E+02  0.138735773647E-06 -0.140343182520E-06  0.146883661132E-07  0.146876225863E-07  0.624154119008E+00
  0.22000000E+02  0.182389541803E-06 -0.191773954383E-06  0.170074316472E-07  0.170062780793E-07  0.624154159641E+00
  0.25000000E+02  0.235519393876E-06 -0.247641387507E-06  0.193264312574E-07  0.193247390249E-07  0.624154207047E+00
  0.28000000E+02  0.298154125278E-06 -0.307915840714E-06  0.216453559264E-07  0.216429787958E-07  0.624154261225E+00
  0.31000000E+02  0.370326001198E-06 -0.372564094353E-06  0.239641966305E-07  0.239609707415E-07  0.624154322176E+00
  0.34000000E+02  0.439690910681E-06 -0.453929212441E-06  0.262829447963E-07  0.262786886374E-07  0.624154386512E+00
  0.37000000E+02  0.518668326843E-06 -0.539590540583E-06  0.286015910113E-07  0.285961054024E-07  0.624154457621E+00
  0.40000000E+02  0.607301113176E-06 -0.629503936200E-06  0.309201262331E-07  0.309131942983E-07  0.624154535501E+00
  0.43000000E+02  0.705635637033E-06 -0.723621643717E-06  0.332385414126E-07  0.332299285552E-07  0.624154620155E+00
  0.46000000E+02  0.813721778958E-06 -0.821892285785E-06  0.355568274937E-07  0.355462813697E-07  0.624154711580E+00
  0.49000000E+02  0.919233786756E-06 -0.936640040639E-06  0.378749760686E-07  0.378622265498E-07  0.624154806392E+00
  0.52000000E+02  0.103460795498E-05 -0.105542687456E-05  0.401929774911E-07  0.401777366548E-07  0.624154907975E+00
  0.55000000E+02  0.115990454108E-05 -0.117819070655E-05  0.425108226838E-07  0.424927847796E-07  0.624155016331E+00
  0.58000000E+02  0.129518722214E-05 -0.130486592642E-05  0.448285025620E-07  0.448073439858E-07  0.624155131460E+00
  0.61000000E+02  0.142814479165E-05 -0.144776174793E-05  0.471460088458E-07  0.471213880957E-07  0.624155249974E+00
  0.64000000E+02  0.157122633115E-05 -0.159442689784E-05  0.494633317023E-07  0.494348893874E-07  0.624155375261E+00
  0.67000000E+02  0.172450554281E-05 -0.174478541293E-05  0.517804620253E-07  0.517478208291E-07  0.624155507320E+00
  0.70000000E+02  0.188805936641E-05 -0.189875798273E-05  0.540973907017E-07  0.540601553616E-07  0.624155646151E+00
  0.73000000E+02  0.204959075578E-05 -0.206863924346E-05  0.564141095789E-07  0.563718668343E-07  0.624155788368E+00
  0.76000000E+02  0.222156079499E-05 -0.224196546172E-05  0.587306086411E-07  0.586829272741E-07  0.624155937358E+00
  0.79000000E+02  0.240405594587E-05 -0.241864747585E-05  0.610468787563E-07  0.609933095516E-07  0.624156093120E+00
  0.82000000E+02  0.258478941217E-05 -0.261096936105E-05  0.633629118682E-07  0.633029875548E-07  0.624156252268E+00
  0.85000000E+02  0.278860659875E-05 -0.279408262160E-05  0.656786967097E-07  0.656119320844E-07  0.624156421574E+00
  0.88000000E+02  0.297847509345E-05 -0.300501692574E-05  0.679942274902E-07  0.679201191689E-07  0.624156590880E+00
  0.91000000E+02  0.319162110884E-05 -0.320654263597E-05  0.703094917007E-07  0.702275184211E-07  0.624156770345E+00
  0.94000000E+02  0.340339492400E-05 -0.342330643444E-05  0.726244825363E-07  0.725341048826E-07  0.624156953196E+00
  0.97000000E+02  0.362627605877E-05 -0.364282534027E-05  0.749391896812E-07  0.748398502609E-07  0.624157142819E+00
  0.10000000E+03  0.386037108047E-05 -0.386498931693E-05  0.772536039739E-07  0.771447273643E-07  0.624157339214E+00
  0.10300000E+03  0.409341535801E-05 -0.410205955403E-05  0.795677175928E-07  0.794487102588E-07  0.624157538996E+00
  0.10600000E+03  0.432552176011E-05 -0.435391951703E-05  0.818815214824E-07  0.817517718513E-07  0.624157742163E+00
  0.10900000E+03  0.458155152316E-05 -0.459570388622E-05  0.841950037562E-07  0.840538824372E-07  0.624157955489E+00
  0.11200000E+03  0.483687478026E-05 -0.485203892020E-05  0.865081580402E-07  0.863550174499E-07  0.624158172202E+00
  0.11500000E+03  0.510398359443E-05 -0.511042839135E-05  0.888209737899E-07  0.886551484673E-07  0.624158395686E+00
  0.11800000E+03  0.537062718875E-05 -0.538311912790E-05  0.911334433615E-07  0.909542497583E-07  0.624158622556E+00
  0.12100000E+03  0.564930100566E-05 -0.565761128735E-05  0.934455561404E-07  0.932522928854E-07  0.624158856199E+00
  0.12400000E+03  0.592775927066E-05 -0.594614649430E-05  0.957573045565E-07  0.955492522143E-07  0.624159093228E+00
  0.12700000E+03  0.621850038096E-05 -0.623622171592E-05  0.980686779282E-07  0.978450993049E-07  0.624159337029E+00
  0.13000000E+03  0.650928318302E-05 -0.654007375589E-05  0.100379668760E-06  0.100139808627E-06  0.624159584216E+00
  0.13300000E+03  0.681260859514E-05 -0.684519682381E-05  0.102690266308E-06  0.102433351749E-06  0.624159838176E+00
  0.13600000E+03  0.712860839547E-05 -0.715145435792E-05  0.105000461422E-06  0.104725701715E-06  0.624160098908E+00
  0.13900000E+03  0.744504768124E-05 -0.747107661325E-05  0.107310246723E-06  0.107016833164E-06  0.624160363026E+00
  0.14200000E+03  0.777443022792E-05 -0.779155458752E-05  0.109619611376E-06  0.109306717697E-06  0.624160633916E+00
  0.14500000E+03  0.810452486355E-05 -0.812511460790E-05  0.111928548079E-06  0.111595330068E-06  0.624160908192E+00
  0.14800000E+03  0.843547021434E-05 -0.847161286077E-05  0.114237047805E-06  0.113882643533E-06  0.624161185854E+00
  0.15100000E+03  0.877977188374E-05 -0.881853816115E-05  0.116545099635E-06  0.116168629747E-06  0.624161470289E+00
  0.15400000E+03  0.913756880516E-05 -0.916574614107E-05  0.118852694456E-06  0.118453261986E-06  0.624161761496E+00
  0.15700000E+03  0.949663601035E-05 -0.952545653399E-05  0.121159825123E-06  0.120736515247E-06  0.624162056089E+00
  0.16000000E+03  0.985711573620E-05 -0.989752148539E-05  0.123466482635E-06  0.123018362949E-06  0.624162354068E+00
  0.16300000E+03  0.102315142797E-04 -0.102694286438E-04  0.125772655972E-06  0.125298776843E-06  0.624162658819E+00
  0.16600000E+03  0.106076103481E-04 -0.106533937779E-04  0.128078338108E-06  0.127577732114E-06  0.624162966957E+00
  0.16900000E+03  0.109979098355E-04 -0.110369047027E-04  0.130383517978E-06  0.129855200572E-06  0.624163281867E+00
  0.17200000E+03  0.113901933761E-04 -0.114321750689E-04  0.132688188635E-06  0.132131157529E-06  0.624163600163E+00
  0.17500000E+03  0.117969660393E-04 -0.118266932800E-04  0.134992338968E-06  0.134405574863E-06  0.624163925231E+00
  0.17800000E+03  0.121936498934E-04 -0.122450317503E-04  0.137295964291E-06  0.136678429799E-06  0.624164250299E+00
  0.18100000E+03  0.126174695502E-04 -0.126499583409E-04  0.139599049122E-06  0.138949690734E-06  0.624164585526E+00
  0.18400000E+03  0.130314889073E-04 -0.130784038487E-04  0.141901591065E-06  0.141219336825E-06  0.624164920752E+00
  0.18700000E+03  0.134605699905E-04 -0.135054988610E-04  0.144203576746E-06  0.143487338321E-06  0.624165262751E+00
  0.19000000E+03  0.138924970335E-04 -0.139434528639E-04  0.146504999460E-06  0.145753670934E-06  0.624165608136E+00
  0.19300000E+03  0.143397697391E-04 -0.143797589202E-04  0.148805847975E-06  0.148018306791E-06  0.624165960293E+00
  0.19600000E+03  0.147778170415E-04 -0.148389820906E-04  0.151106118021E-06  0.150281223607E-06  0.624166312450E+00
  0.19900000E+03  0.152314932601E-04 -0.152962601507E-04  0.153405796034E-06  0.152542391777E-06  0.624166671380E+00
  0.20200000E+03  0.157009374372E-04 -0.157514469202E-04  0.155704873056E-06  0.154801785434E-06  0.624167037081E+00
  0.20500000E+03  0.161615809834E-04 -0.162291047464E-04  0.158003345023E-06  0.157059382556E-06  0.624167402783E+00
  0.20800000E+03  0.166382711788E-04 -0.167043780542E-04  0.160301198236E-06  0.159315153688E-06  0.624167775257E+00
  0.21100000E+03  0.171187925357E-04 -0.171894754073E-04  0.162598426270E-06  0.161569075091E-06  0.624168151117E+00
  0.21400000E+03  0.176032827460E-04 -0.176842515989E-04  0.164895020303E-06  0.163821121231E-06  0.624168530363E+00
  0.21700000E+03  0.181042285053E-04 -0.181762117627E-04  0.167190968977E-06  0.166071264740E-06  0.624168916382E+00
  0.22000000E+03  0.186094133749E-04 -0.186775651430E-04  0.169486265991E-06  0.168319482163E-06  0.624169305786E+00
  0.22300000E+03  0.191066230414E-04 -0.192005188103E-04  0.171780905164E-06  0.170565750169E-06  0.624169695191E+00
  0.22600000E+03  0.196330355254E-04 -0.197078850783E-04  0.174074869928E-06  0.172810037798E-06  0.624170094754E+00
  0.22900000E+03  0.201517369616E-04 -0.202365715258E-04  0.176368159334E-06  0.175052325791E-06  0.624170494317E+00
  0.23200000E+03  0.206752056874E-04 -0.207740911071E-04  0.178660762045E-06  0.177292587272E-06  0.624170897266E+00
  0.23500000E+03  0.212159149841E-04 -0.213079616763E-04  0.180952666640E-06  0.179530795460E-06  0.624171306987E+00
  0.23800000E+03  0.217493010914E-04 -0.218627399207E-04  0.183243869799E-06  0.181766929564E-06  0.624171716708E+00
  0.24100000E+03  0.223001779892E-04 -0.224136021457E-04  0.185534357406E-06  0.184000961099E-06  0.624172133202E+00
  0.24400000E+03  0.228563243921E-04 -0.229727617425E-04  0.187824123502E-06  0.186232867597E-06  0.624172553082E+00
  0.24700000E+03  0.234178621071E-04 -0.235400882753E-04  0.190113159443E-06  0.188462624781E-06  0.624172976347E+00
  0.25000000E+03  0.239849112327E-04 -0.241154529185E-04  0.192401456604E-06  0.190690208531E-06  0.624173402999E+00
  0.25300000E+03  0.245699292013E-04 -0.246863886928E-04  0.194689003534E-06  0.192915592906E-06  0.624173836424E+00
  0.25600000E+03  0.251483531648E-04 -0.252774509515E-04  0.196975797329E-06  0.195138758088E-06  0.624174269848E+00
  0.25900000E+03  0.257326378675E-04 -0.258761752240E-04  0.199261826608E-06  0.197359678497E-06  0.624174706658E+00
  0.26200000E+03  0.263352321951E-04 -0.264701027431E-04  0.201547079917E-06  0.199578328727E-06  0.624175150241E+00
  0.26500000E+03  0.269315735900E-04 -0.270837883707E-04  0.203831554569E-06  0.201794689559E-06  0.624175593823E+00
  0.26800000E+03  0.275464422181E-04 -0.276924410889E-04  0.206115236220E-06  0.204008734000E-06  0.624176044178E+00
  0.27100000E+03  0.281552757010E-04 -0.283206154507E-04  0.208398122331E-06  0.206220443275E-06  0.624176494533E+00
  0.27400000E+03  0.287828461617E-04 -0.289435282335E-04  0.210680198522E-06  0.208429790828E-06  0.624176951660E+00
  0.27700000E+03  0.294045914569E-04 -0.295857336293E-04  0.212961462405E-06  0.210636758369E-06  0.624177408787E+00
  0.28000000E+03  0.300452754978E-04 -0.302224563830E-04  0.215241899574E-06  0.212841319822E-06  0.624177872687E+00
  0.28300000E+03  0.306803363861E-04 -0.308782503191E-04  0.217521507792E-06  0.215043457419E-06  0.624178336586E+00
  0.28600000E+03  0.313345297359E-04 -0.315283482378E-04  0.219800272635E-06  0.217243145608E-06  0.624178807258E+00
  0.28900000E+03  0.319832940018E-04 -0.321973034931E-04  0.222078192024E-06  0.219440367187E-06  0.624179277929E+00
  0.29200000E+03  0.326513763510E-04 -0.328603570929E-04  0.224355251520E-06  0.221635097169E-06  0.624179755373E+00
  0.29500000E+03  0.333142156642E-04 -0.335420618521E-04  0.226631449208E-06  0.223827318961E-06  0.624180232817E+00
  0.29800000E+03  0.339965506536E-04 -0.342176669983E-04  0.228906770644E-06  0.226017008183E-06  0.624180717033E+00
  0.30100000E+03  0.346738207049E-04 -0.349117247326E-04  0.231181214078E-06  0.228204148896E-06  0.624181201249E+00
  0.30400000E+03  0.353584350903E-04 -0.356118144713E-04  0.233454768295E-06  0.230388719408E-06  0.624181688851E+00
  0.30700000E+03  0.360504768231E-04 -0.363178427398E-04  0.235727425286E-06  0.232570700404E-06  0.624182179840E+00
  0.31000000E+03  0.367500269073E-04 -0.370297179916E-04  0.237999177093E-06  0.234750072927E-06  0.624182674214E+00
  0.31300000E+03  0.374571644287E-04 -0.377473505176E-04  0.240270015803E-06  0.236926818389E-06  0.624183171975E+00
  0.31600000E+03  0.381719665592E-04 -0.384706524441E-04  0.242539933555E-06  0.239100918581E-06  0.624183673122E+00
  0.31900000E+03  0.388945085407E-04 -0.391995377494E-04  0.244808922540E-06  0.241272355683E-06  0.624184177655E+00
  0.32200000E+03  0.396248638039E-04 -0.399339221467E-04  0.247076975002E-06  0.243441112278E-06  0.624184685574E+00
  0.32500000E+03  0.403631038560E-04 -0.406737231978E-04  0.249344083243E-06  0.245607171355E-06  0.624185196879E+00
  0.32800000E+03  0.410969872868E-04 -0.414311724178E-04  0.251610243002E-06  0.247770518380E-06  0.624185708184E+00
  0.33100000E+03  0.418388956455E-04 -0.421938761043E-04  0.253875443353E-06  0.249931135145E-06  0.624186222875E+00
  0.33400000E+03  0.426012037079E-04 -0.429494471915E-04  0.256139673352E-06  0.252089003870E-06  0.624186744339E+00
  0.33700000E+03  0.433593574359E-04 -0.437224307699E-04  0.258402932361E-06  0.254244113400E-06  0.624187265802E+00
  0.34000000E+03  0.441257294330E-04 -0.445004418260E-04  0.260665209585E-06  0.256396446865E-06  0.624187790652E+00
  0.34300000E+03  0.448880760223E-04 -0.452957138793E-04  0.262926501171E-06  0.258545991984E-06  0.624188315501E+00
  0.34600000E+03  0.456710673088E-04 -0.460835630426E-04  0.265186792923E-06  0.260692730752E-06  0.624188847123E+00
  0.34900000E+03  0.464624550791E-04 -0.468762272279E-04  0.267446081109E-06  0.262836651846E-06  0.624189382131E+00
  0.35200000E+03  0.472499949002E-04 -0.476859405730E-04  0.269704362140E-06  0.264977744443E-06  0.624189917139E+00
  0.35500000E+03  0.480460448102E-04 -0.485003322337E-04  0.271961625476E-06  0.267115994073E-06  0.624190455534E+00
  0.35800000E+03  0.488506580494E-04 -0.493193373147E-04  0.274217864145E-06  0.269251388843E-06  0.624190997314E+00
  0.36100000E+03  0.496638863827E-04 -0.501428923403E-04  0.276473071255E-06  0.271383917374E-06  0.624191542480E+00
  0.36400000E+03  0.504734849411E-04 -0.509832317259E-04  0.278727243591E-06  0.273513570892E-06  0.624192087647E+00
  0.36700000E+03  0.513040944666E-04 -0.518157003073E-04  0.280980367232E-06  0.275640334892E-06  0.624192639585E+00
  0.37000000E+03  0.521311736474E-04 -0.526648301685E-04  0.283232442746E-06  0.277764203751E-06  0.624193191524E+00
  0.37300000E+03  0.529670640202E-04 -0.535182665456E-04  0.285483459962E-06  0.279885166116E-06  0.624193746849E+00
  0.37600000E+03  0.538118106738E-04 -0.543759523872E-04  0.287733412396E-06  0.282003213268E-06  0.624194305560E+00
  0.37900000E+03  0.546654574903E-04 -0.552378318033E-04  0.289982293651E-06  0.284118337034E-06  0.624194867657E+00
  0.38200000E+03  0.555157605679E-04 -0.561161380613E-04  0.292230101124E-06  0.286230531902E-06  0.624195429754E+00
  0.38500000E+03  0.563750510130E-04 -0.569985265829E-04  0.294476824924E-06  0.288339788706E-06  0.624195995237E+00
  0.38800000E+03  0.572433693834E-04 -0.578849446798E-04  0.296722458926E-06  0.290446100947E-06  0.624196564106E+00
  0.39100000E+03  0.581207551212E-04 -0.587753407427E-04  0.298966997095E-06  0.292549462685E-06  0.624197136361E+00
  0.39400000E+03  0.589949660139E-04 -0.596819462685E-04  0.301210437265E-06  0.294649870670E-06  0.624197708617E+00
  0.39700000E+03  0.598906025036E-04 -0.605801456238E-04  0.303452766064E-06  0.296747315865E-06  0.624198287645E+00
  0.40000000E+03  0.607831412748E-04 -0.614944528491E-04  0.305693985310E-06  0.298841798284E-06  0.624198866672E+00
  0.40300000E+03  0.616848987826E-04 -0.624125377070E-04  0.307934085582E-06  0.300933312153E-06  0.624199449086E+00
  0.40600000E+03  0.625836353237E-04 -0.633466291371E-04  0.310173065174E-06  0.303021856527E-06  0.624200031500E+00
  0.40900000E+03  0.634916627565E-04 -0.642844014109E-04  0.312410914835E-06  0.305107426778E-06  0.624200617300E+00
  0.41200000E+03  0.644090144727E-04 -0.652258087668E-04  0.314647629222E-06  0.307190020983E-06  0.624201206486E+00
  0.41500000E+03  0.653357231937E-04 -0.661708060917E-04  0.316883203097E-06  0.309269637796E-06  0.624201799058E+00
  0.41800000E+03  0.662718209339E-04 -0.671193489615E-04  0.319117631329E-06  0.311346276451E-06  0.624202395016E+00
  0.42100000E+03  0.672050723317E-04 -0.680836619606E-04  0.321350912809E-06  0.313419938909E-06  0.624202990975E+00
  0.42400000E+03  0.681477781701E-04 -0.690514302517E-04  0.323583038731E-06  0.315490623418E-06  0.624203590319E+00
  0.42700000E+03  0.690999687967E-04 -0.700226110328E-04  0.325814004285E-06  0.317558330942E-06  0.624204193050E+00
  0.43000000E+03  0.700494120460E-04 -0.710094257101E-04  0.328043808735E-06  0.319623065184E-06  0.624204795780E+00
  0.43300000E+03  0.710206628258E-04 -0.719873035104E-04  0.330272439576E-06  0.321684823944E-06  0.624205405283E+00
  0.43600000E+03  0.719892277706E-04 -0.729807287490E-04  0.332499900274E-06  0.323743614232E-06  0.624206014786E+00
  0.43900000E+03  0.729551403724E-04 -0.739896555056E-04  0.334726186510E-06  0.325799439312E-06  0.624206624288E+00
  0.44200000E+03  0.739429446072E-04 -0.749895238139E-04  0.336951286020E-06  0.327852298680E-06  0.624207240564E+00
  0.44500000E+03  0.749281559573E-04 -0.760048092463E-04  0.339175202705E-06  0.329902201061E-06  0.624207856839E+00
  0.44800000E+03  0.759108071052E-04 -0.770354666921E-04  0.341397932583E-06  0.331949151413E-06  0.624208473114E+00
  0.45100000E+03  0.769154312389E-04 -0.780569468648E-04  0.343619463644E-06  0.333993150899E-06  0.624209096161E+00
  0.45400000E+03  0.779175532148E-04 -0.790937160874E-04  0.345839800225E-06  0.336034209932E-06  0.624209719208E+00
  0.45700000E+03  0.789294521701E-04 -0.801334809373E-04  0.348058934589E-06  0.338072332950E-06  0.624210345642E+00
  0.46000000E+03  0.799511550535E-04 -0.811762020075E-04  0.350276863176E-06  0.340107527112E-06  0.624210975461E+00
  0.46300000E+03  0.809704452178E-04 -0.822340854127E-04  0.352493586675E-06  0.342139802302E-06  0.624211605281E+00
  0.46600000E+03  0.819995964396E-04 -0.832948430688E-04  0.354709097658E-06  0.344169164575E-06  0.624212238487E+00
  0.46900000E+03  0.830386355130E-04 -0.843584357649E-04  0.356923392917E-06  0.346195622698E-06  0.624212875078E+00
  0.47200000E+03  0.840753509507E-04 -0.854370645607E-04  0.359136473541E-06  0.348219188154E-06  0.624213511670E+00
  0.47500000E+03  0.851220113568E-04 -0.865184465397E-04  0.361348332414E-06  0.350239868571E-06  0.624214151648E+00
  0.47800000E+03  0.861786436549E-04 -0.876025424207E-04  0.363558966685E-06  0.352257674277E-06  0.624214795012E+00
  0.48100000E+03  0.872330418982E-04 -0.887015478456E-04  0.365768377846E-06  0.354272618303E-06  0.624215438376E+00
  0.48400000E+03  0.882974697063E-04 -0.898031848948E-04  0.367976559093E-06  0.356284709798E-06  0.624216085126E+00
  0.48700000E+03  0.893719543802E-04 -0.909074139853E-04  0.370183507937E-06  0.358293960599E-06  0.624216735263E+00
  0.49000000E+03  0.904565233679E-04 -0.920141954159E-04  0.372389222008E-06  0.360300383033E-06  0.624217388785E+00
  0.49300000E+03  0.915389786235E-04 -0.931357171189E-04  0.374593703331E-06  0.362303992107E-06  0.624218042308E+00
  0.49600000E+03  0.926193535692E-04 -0.942719335413E-04  0.376796949819E-06  0.364304801106E-06  0.624218695830E+00
  0.49900000E+03  0.937221258712E-04 -0.953983506254E-04  0.378998950895E-06  0.366302819399E-06  0.624219356125E+00
  0.50200000E+03  0.948228781330E-04 -0.965393779251E-04  0.381199713263E-06  0.368298065593E-06  0.624220016420E+00
  0.50500000E+03  0.959338629690E-04 -0.976827486167E-04  0.383399230863E-06  0.370290552166E-06  0.624220680100E+00
  0.50800000E+03  0.970428930215E-04 -0.988406402240E-04  0.385597506389E-06  0.372280296432E-06  0.624221343781E+00
  0.51100000E+03  0.981622179054E-04 -0.100000788965E-03  0.387794533992E-06  0.374267311760E-06  0.624222010848E+00
  0.51400000E+03  0.992918674396E-04 -0.101163153063E-03  0.389990312261E-06  0.376251614143E-06  0.624222681301E+00
  0.51700000E+03  0.100419661039E-03 -0.102339903459E-03  0.392184844290E-06  0.378233222187E-06  0.624223351754E+00
  0.52000000E+03  0.101557843906E-03 -0.103518780857E-03  0.394378124544E-06  0.380212150537E-06  0.624224025594E+00
  0.52300000E+03  0.102694240091E-03 -0.104711951697E-03  0.396570156382E-06  0.382188418620E-06  0.624224699433E+00
  0.52600000E+03  0.103841091938E-03 -0.105907159598E-03  0.398760934479E-06  0.384162041894E-06  0.624225376658E+00
  0.52900000E+03  0.104998431421E-03 -0.107104360869E-03  0.400950458016E-06  0.386133038399E-06  0.624226057270E+00
  0.53200000E+03  0.106166290953E-03 -0.108303511433E-03  0.403138726289E-06  0.388101426557E-06  0.624226741267E+00
  0.53500000E+03  0.107332504298E-03 -0.109516768303E-03  0.405325743179E-06  0.390067227335E-06  0.624227425265E+00
  0.53800000E+03  0.108497110727E-03 -0.110744080713E-03  0.407511508253E-06  0.392030459889E-06  0.624228109262E+00
  0.54100000E+03  0.109684540821E-03 -0.111961001787E-03  0.409696012215E-06  0.393991139417E-06  0.624228800032E+00
  0.54400000E+03  0.110870436489E-03 -0.113191883015E-03  0.411879263794E-06  0.395949290118E-06  0.624229490802E+00
  0.54700000E+03  0.112054838764E-03 -0.114436672044E-03  0.414061262902E-06  0.397904932198E-06  0.624230181572E+00
  0.55000000E+03  0.113249978672E-03 -0.115683124099E-03  0.416242005039E-06  0.399858084055E-06  0.624230875728E+00
  0.55300000E+03  0.114455892488E-03 -0.116931191652E-03  0.418421490306E-06  0.401808766571E-06  0.624231573270E+00
  0.55600000E+03  0.115660431665E-03 -0.118193014585E-03  0.420599723471E-06  0.403757003075E-06  0.624232270812E+00
  0.55900000E+03  0.116875823076E-03 -0.119456352410E-03  0.422776700332E-06  0.405702812934E-06  0.624232971740E+00
  0.56200000E+03  0.118089923442E-03 -0.120733339916E-03  0.424952425903E-06  0.407646220071E-06  0.624233672669E+00
  0.56500000E+03  0.119314956872E-03 -0.122011739469E-03  0.427126896179E-06  0.409587244458E-06  0.624234376983E+00
  0.56800000E+03  0.120550962738E-03 -0.123291500774E-03  0.429300111816E-06  0.411525908480E-06  0.624235084683E+00
  0.57100000E+03  0.121785805693E-03 -0.124584750955E-03  0.431472078193E-06  0.413462236887E-06  0.624235792384E+00
  0.57400000E+03  0.123031705786E-03 -0.125879256589E-03  0.433642791594E-06  0.415396250498E-06  0.624236503470E+00
  0.57700000E+03  0.124276533078E-03 -0.127187139577E-03  0.435812257634E-06  0.417327974569E-06  0.624237214557E+00
  0.58000000E+03  0.125532504832E-03 -0.128496169385E-03  0.437980472788E-06  0.419257430444E-06  0.624237929030E+00
  0.58300000E+03  0.126799663676E-03 -0.129806292821E-03  0.440147438246E-06  0.421184641798E-06  0.624238646889E+00
  0.58600000E+03  0.128053722921E-03 -0.131141791560E-03  0.442313164643E-06  0.423109636623E-06  0.624239361361E+00
  0.58900000E+03  0.129331227739E-03 -0.132466101869E-03  0.444477639403E-06  0.425032432896E-06  0.624240082606E+00
  0.59200000E+03  0.130607894877E-03 -0.133803502161E-03  0.446640873376E-06  0.426953059037E-06  0.624240803851E+00
  0.59500000E+03  0.131895934667E-03 -0.135141769112E-03  0.448802863494E-06  0.428871537562E-06  0.624241528482E+00
  0.59800000E+03  0.133183236552E-03 -0.136493005920E-03  0.450963616174E-06  0.430787895223E-06  0.624242253114E+00
  0.60100000E+03  0.134469853534E-03 -0.137857149549E-03  0.453123133250E-06  0.432702156932E-06  0.624242977745E+00
  0.60400000E+03  0.135780144168E-03 -0.139209825770E-03  0.455281407183E-06  0.434614343844E-06  0.624243709148E+00
  0.60700000E+03  0.137077699387E-03 -0.140587442297E-03  0.457438454174E-06  0.436524487175E-06  0.624244437165E+00
  0.61000000E+03  0.138399025180E-03 -0.141953474708E-03  0.459594262112E-06  0.438432606494E-06  0.624245171955E+00
  0.61300000E+03  0.139707726627E-03 -0.143344316862E-03  0.461748847453E-06  0.440338733260E-06  0.624245903358E+00
  0.61600000E+03  0.141040298351E-03 -0.144723455746E-03  0.463902198209E-06  0.442242887439E-06  0.624246641534E+00
  0.61900000E+03  0.142360359656E-03 -0.146127271286E-03  0.466054331086E-06  0.444145100696E-06  0.624247376323E+00
  0.62200000E+03  0.143692254167E-03 -0.147531404501E-03  0.468205239017E-06  0.446045395247E-06  0.624248114499E+00
  0.62500000E+03  0.145036034171E-03 -0.148935793678E-03  0.470354924558E-06  0.447943797291E-06  0.624248856061E+00
  0.62800000E+03  0.146379617411E-03 -0.150352514758E-03  0.472503395173E-06  0.449840334993E-06  0.624249597622E+00
  0.63100000E+03  0.147735197117E-03 -0.151769362275E-03  0.474650648800E-06  0.451735032908E-06  0.624250342570E+00
  0.63400000E+03  0.149090696771E-03 -0.153198406652E-03  0.476796693095E-06  0.453627919389E-06  0.624251087518E+00
  0.63700000E+03  0.150458306651E-03 -0.154627445507E-03  0.478941526152E-06  0.455519019229E-06  0.624251835852E+00
  0.64000000E+03  0.151825955956E-03 -0.156068543767E-03  0.481085155816E-06  0.457408360937E-06  0.624252584186E+00
  0.64300000E+03  0.153193707690E-03 -0.157521629589E-03  0.483227585193E-06  0.459295971272E-06  0.624253332520E+00
  0.64600000E+03  0.154573747617E-03 -0.158974505321E-03  0.485368812598E-06  0.461181875340E-06  0.624254084240E+00
  0.64900000E+03  0.155966133489E-03 -0.160427104495E-03  0.487508841270E-06  0.463066100108E-06  0.624254839347E+00
  0.65200000E+03  0.157358806063E-03 -0.161891480919E-03  0.489647679420E-06  0.464948674303E-06  0.624255594453E+00
  0.65500000E+03  0.158751831002E-03 -0.163367560460E-03  0.491785330476E-06  0.466829624955E-06  0.624256349559E+00
  0.65800000E+03  0.160157387998E-03 -0.164843151818E-03  0.493921793034E-06  0.468708977489E-06  0.624257108051E+00
  0.66100000E+03  0.161563426382E-03 -0.166330300565E-03  0.496057075562E-06  0.470586760723E-06  0.624257866544E+00
  0.66400000E+03  0.162982122695E-03 -0.167816818697E-03  0.498191176795E-06  0.472463000208E-06  0.624258628422E+00
  0.66700000E+03  0.164401432039E-03 -0.169314746240E-03  0.500324105365E-06  0.474337724786E-06  0.624259390301E+00
  0.67000000E+03  0.165821423419E-03 -0.170824006182E-03  0.502455865077E-06  0.476210961668E-06  0.624260152179E+00
  0.67300000E+03  0.167254268590E-03 -0.172332415527E-03  0.504586454854E-06  0.478082736553E-06  0.624260917444E+00
  0.67600000E+03  0.168687931297E-03 -0.173852005999E-03  0.506715883573E-06  0.479953078266E-06  0.624261682709E+00
  0.67900000E+03  0.170134580037E-03 -0.175370598005E-03  0.508844150282E-06  0.481822012573E-06  0.624262451359E+00
  0.68200000E+03  0.171582184256E-03 -0.176900217799E-03  0.510971264010E-06  0.483689568260E-06  0.624263220010E+00
  0.68500000E+03  0.173030816142E-03 -0.178440785657E-03  0.513097228903E-06  0.485555772571E-06  0.624263988661E+00
  0.68800000E+03  0.174492639211E-03 -0.179980127191E-03  0.515222044189E-06  0.487420651335E-06  0.624264760698E+00
  0.69100000E+03  0.175955631520E-03 -0.181530260388E-03  0.517345719115E-06  0.489284233228E-06  0.624265532735E+00
  0.69400000E+03  0.177419867040E-03 -0.183091104026E-03  0.519468258019E-06  0.491146545446E-06  0.624266304772E+00
  0.69700000E+03  0.178897504226E-03 -0.184650489004E-03  0.521589660300E-06  0.493007613834E-06  0.624267080195E+00
  0.70000000E+03  0.180376529685E-03 -0.186220425103E-03  0.523709935411E-06  0.494867466907E-06  0.624267855618E+00
  0.70300000E+03  0.181869098444E-03 -0.187788746802E-03  0.525829082854E-06  0.496726130498E-06  0.624268634427E+00
  0.70600000E+03  0.183363202774E-03 -0.189367458451E-03  0.527947112216E-06  0.498583632987E-06  0.624269413236E+00
  0.70900000E+03  0.184858919446E-03 -0.190956476500E-03  0.530064028133E-06  0.500440001383E-06  0.624270192045E+00
  0.71200000E+03  0.186356325766E-03 -0.192555716966E-03  0.532179835298E-06  0.502295262641E-06  0.624270970854E+00
  0.71500000E+03  0.187867569711E-03 -0.194153021683E-03  0.534294533418E-06  0.504149442515E-06  0.624271753049E+00
  0.71800000E+03  0.189380654864E-03 -0.195760384144E-03  0.536408132323E-06  0.506002569049E-06  0.624272535245E+00
  0.72100000E+03  0.190907725594E-03 -0.197365649944E-03  0.538520631814E-06  0.507854667931E-06  0.624273320826E+00
  0.72400000E+03  0.192424727895E-03 -0.198992874059E-03  0.540632046898E-06  0.509705768059E-06  0.624274103021E+00
  0.72700000E+03  0.193955870331E-03 -0.200617834417E-03  0.542742372417E-06  0.511555893925E-06  0.624274888603E+00
  0.73000000E+03  0.195501226261E-03 -0.202240451493E-03  0.544851613362E-06  0.513405072174E-06  0.624275677570E+00
  0.73300000E+03  0.197036757005E-03 -0.203884765338E-03  0.546959784915E-06  0.515253331269E-06  0.624276463152E+00
  0.73600000E+03  0.198586658599E-03 -0.205526566578E-03  0.549066882034E-06  0.517100695652E-06  0.624277252119E+00
  0.73900000E+03  0.200138954152E-03 -0.207177829982E-03  0.551172914931E-06  0.518947192591E-06  0.624278041087E+00
  0.74200000E+03  0.201693725815E-03 -0.208838467672E-03  0.553277888797E-06  0.520792848274E-06  0.624278830054E+00
  0.74500000E+03  0.203263103022E-03 -0.210496340787E-03  0.555381803770E-06  0.522637687981E-06  0.624279622408E+00
  0.74800000E+03  0.204835117151E-03 -0.212163416165E-03  0.557484670209E-06  0.524481738579E-06  0.624280414761E+00
  0.75100000E+03  0.206409851586E-03 -0.213839604979E-03  0.559586493430E-06  0.526325025951E-06  0.624281207115E+00
  0.75400000E+03  0.207987390066E-03 -0.215524818139E-03  0.561687278787E-06  0.528167575867E-06  0.624281999469E+00
  0.75700000E+03  0.209579854294E-03 -0.217206924819E-03  0.563787026569E-06  0.530009413320E-06  0.624282795209E+00
  0.76000000E+03  0.211163251397E-03 -0.218909920441E-03  0.565885752419E-06  0.531850565218E-06  0.624283587562E+00
  0.76300000E+03  0.212761738941E-03 -0.220609634621E-03  0.567983451588E-06  0.533691055693E-06  0.624284383302E+00
  0.76600000E+03  0.214363364653E-03 -0.222318018518E-03  0.570080134688E-06  0.535530910707E-06  0.624285179042E+00
  0.76900000E+03  0.215980242190E-03 -0.224022949655E-03  0.572175802139E-06  0.537370154925E-06  0.624285978168E+00
  0.77200000E+03  0.217588398945E-03 -0.225748403704E-03  0.574270469753E-06  0.539208814450E-06  0.624286773907E+00
  0.77500000E+03  0.219211974961E-03 -0.227470228030E-03  0.576364132892E-06  0.541046913215E-06  0.624287573033E+00
  0.77800000E+03  0.220839028683E-03 -0.229200363518E-03  0.578456802314E-06  0.542884476509E-06  0.624288372159E+00
  0.78100000E+03  0.222469646941E-03 -0.230938718820E-03  0.580548483689E-06  0.544721528976E-06  0.624289171285E+00
  0.78400000E+03  0.224103916896E-03 -0.232685202351E-03  0.582639182714E-06  0.546558095118E-06  0.624289970411E+00
  0.78700000E+03  0.225741925929E-03 -0.234439722397E-03  0.584728905115E-06  0.548394199294E-06  0.624290769537E+00
  0.79000000E+03  0.227383761713E-03 -0.236202187039E-03  0.586817656648E-06  0.550229865720E-06  0.624291568663E+00
  0.79300000E+03  0.229041521363E-03 -0.237960490935E-03  0.588905437954E-06  0.552065118279E-06  0.624292371175E+00
  0.79600000E+03  0.230703279115E-03 -0.239726559825E-03  0.590992259974E-06  0.553899981161E-06  0.624293173687E+00
  0.79900000E+03  0.232369123387E-03 -0.241500301317E-03  0.593078128541E-06  0.555734478132E-06  0.624293976199E+00
