<p align="justify"> 
<code>Thermo_pw</code> is a Fortran driver designed for the parallel and/or automated computation of material properties. It leverages the powerful routines of Quantum ESPRESSO (QE) as its core engine. For common tasks, <code>thermo_pw</code> offers an alternative workflow organization compared to QE, utilizing asynchronous image parallelization where possible. Furthermore, the code includes pre-processing tools to streamline user input and post-processing tools to generate plots directly comparable with experimental data.</p>

<p align="justify">Get started with <code>thermo_pw</code>:</p>
Quick Introduction: <a href="https://dalcorso.github.io/thermo_pw/thermo_pw_help.html"> click here</a>.

Brief Tutorial: <a href="https://people.sissa.it/dalcorso/thermo_pw/tutorial/tutorial.html"> click here</a>.

User's Guide (Version 2.1.1):<a href="https://people.sissa.it/dalcorso/thermo_pw/user_guide/index.html"> click here</a>.
<br>
<p align="justify">Currently, there is no dedicated publication for citing <code>thermo_pw</code>. If you wish to reference it in your work, please cite this webpage.</p>

<p align="justify">The following publications describe new
features implemented in <code>thermo_pw</code>:</p>

<p align="justify">
20. X. Gong and A. Dal Corso,
High pressure and temperature thermoelasticity of hcp osmium from ab initio quasi-harmonic theory, 
<a href="https://doi.org/10.1103/j1sn-dqbl">
Phys. Rev. B <b>112</b>, 024103 (2025)</a>.</p>
<p align="justify">
19. X. Gong and A. Dal Corso,
High-pressure and high-temperature thermoelasticity of tantalum: 
an ab-initio study,
<a href="https://doi.org/10.1063/5.0258989">
Jour. Chem. Phys. <b>162</b>, 124709 (2025)</a>.</p>
<p align="justify">
18. X. Gong and A. Dal Corso,
An alternative GPU acceleration for a pseudopotential plane-waves 
density functional theory code with applications to metallic systems,
<a href="https://arxiv.org/abs/2412.01695">
Comp. Phys. Comm. <b>308</b>, 109439 (2025)</a>.</p>
<p align="justify">
17. X. Gong and A. Dal Corso,
High temperature and pressure thermoelasticity of hcp metals from 
ab initio quasi-harmonic free energy calculations: the beryllium case
<a href="https://journals.aps.org/prb/abstract/10.1103/PhysRevB.110.094109">
Phys. Rev. B <b>110</b>, 094109 (2024)</a>.</p>
<p align="justify">
16. X. Gong and A. Dal Corso,
Ab-initio quasi-harmonic thermoelasticity of molybdenum at 
high temperature and pressure,
<a href="https://pubs.aip.org/aip/jcp/article/160/24/244703/3299207/Ab-initio-quasi-harmonic-thermoelasticity-of">
Jour. Chem. Phys. <b>160</b>, 244703 (2024)</a>.</p>
<p align="justify">
15. B. Thakur, X. Gong, and A. Dal Corso,
Thermodynamic properties of Rhodium: A first principles study,
<a href="https://doi.org/10.1063/5.0203098"> AIP Advances <b>14</b>, 
045229 (2024)</a>.</p>
<p align="justify">
14. X. Gong and A. Dal Corso,
Pressure and temperature dependent ab-initio
quasi-harmonic thermoelastic properties of tungsten,
<a href="https://iopscience.iop.org/article/10.1088/1361-648X/ad3ac3">
Jour. of Phys.: Condens. Matter <b>36</b>, 285702 (2024)</a>.</p>
<p align="justify">
13. B. Thakur, X. Gong and A. Dal Corso,
Ab initio thermodynamic properties of Iridium: A high-pressure and high-temperature study,
<a href="https://doi.org/10.1016/j.commatsci.2024.112797">
Comp. Materials Science <B>234</B>, 112797 (2024)</a>.</p>
<p align="justify">
12. C. Malica and A. Dal Corso,
Quasi-harmonic thermoelasticity of palladium, platinum, copper and gold
from first principles,
<a href="https://iopscience.iop.org/article/10.1088/1361-648X/ac2041">
J. of Phys.: Condens. Matter <B>33</B>, 475901 (2021)</a>.</p>
<p align="justify">
11. O. Motornyi, N. Vast, I. Timrov, O. Baseggio, S. Baroni, and A. Dal Corso,
Electron energy loss spectroscopy of bulk gold with ultrasoft pseudopotentials and the Liouville-Lanczos method,
<a href="https://journals.aps.org/prb/abstract/10.1103/PhysRevB.102.035156">
Phys. Rev. B <B>102</B>, 035156 (2020)</a>.</p>
<p align="justify">
10. C. Malica and A. Dal Corso,
Quasi-harmonic temperature dependent elastic constants: Applications 
to Silicon, Aluminum, and Silver,
<a href="https://iopscience.iop.org/article/10.1088/1361-648X/ab8426/meta">
J. of Phys.: Condens. Matter <B>32</B>, 315902 (2020)</a>.</p>
<p align="justify">
9. A. Urru and A. Dal Corso,
Density functional perturbation theory for lattice dynamics with fully
relativistic ultrasoft pseudopotentials: The magnetic case,
<a href="https://journals.aps.org/prb/abstract/10.1103/PhysRevB.100.045115">Phys. Rev. B <B>100</B>, 045115 (2019)</a>.</p>
<p align="justify">
8. C. Malica and A. Dal Corso,
Temperature dependent atomic B-factor: an ab-initio calculation,
<a href="https://doi.org/10.1107/S205327331900514X">Acta Cryst. A <B>75</B>, 624 (2019)</a>.</p>
<p align="justify">
7. A. Urru and A. Dal Corso,
Spin-polarized electronic surface states of Re(0001): an ab-initio investigation,
<a href="https://doi.org/10.1016/j.susc.2019.03.008">Surf. Sci. <B>686</B>, 22 (2019)</a>.</p>
<p align="justify">
6. O. Motornyi, M. Raynaud, A. Dal Corso, and N. Vast,
Simulation of electron energy loss spectra with the turboEELS and
thermo&#95;pw codes,
<a href="https://iopscience.iop.org/article/10.1088/1742-6596/1136/1/012008/meta">J. Phys.: Conf. Ser. <B>1136</B>, 012008 (2018)</a>.</p>
<p align="justify">
5. A. Urru and A. Dal Corso,
Clean Os(0001) electronic surface states: a first-principle fully relativistic investigation,
<a href="https://www.sciencedirect.com/science/article/pii/S0039602817309469">Surf. Sci. <B> 671</B>, 17 (2018)</a>.</p>
<p align="justify">
4. M. Palumbo and A. Dal Corso,
Lattice dynamics and thermophysical properties of h.c.p. Os and Ru from
the quasi-harmonic approximation,
<a href="http://iopscience.iop.org/article/10.1088/1361-648X/aa7dca">
J. of Phys.: Condens. Matter <B>29</B>, 395401 (2017)
</a>.</p>
<p align="justify">
3. M. Palumbo and A. Dal Corso,
Lattice dynamics and thermophysical properties of h.c.p. Re and Tc from
the quasi-harmonic approximation,
<a href="http://dx.doi.org/10.1002/pssb.201700101">Physica Status Solidi B:
Basic Solid State Physics <B>254</B>, 1700101 (2017)
</a>.</p>
<p align="justify">
2. A. Dal Corso,
Elastic constants of Beryllium: a first-principles investigation,
<a href="http://dx.doi.org/10.1088/0953-8984/28/7/075401"> J. Phys.: Condens. Matter <B>28</B>, 075401 (2016) </a>.</p>
<p align="justify">
1. A. Dal Corso,
Clean Ir(111) and Pt(111) electronic surface states: a first-principle fully relativistic investigation,
<a href="http://www.sciencedirect.com/science/article/pii/S0039602815000734"> Surf. Sci. <B>637-638</B>, 106 (2015)</a>.</p>
<br>
<p align="justify">Refs.12,10 describe how <code>thermo_pw</code> computes temperature
dependent elastic constants, Ref.14,16,17,19,20 pressure and temperature 
dependent
elastic constants, Ref.2 elastic constants at T=0 K,
Ref.1,5,7 surface band structures, Refs.6,11 eels and optical properties,
Ref.8 the calculation of the atomic B factor,
Ref.9 DFPT with fully relativistic pseudopotentials, and Ref.3,4
thermodynamic anharmonic properties. Refs.13,14,15,16,17,19,20 have 
examples of pressure and temperature parameterized plots.
Ref.18 describes the GPU acceleration for the <code>many_k</code> option.</p>

<p align="justify">The following works contain some calculations made by <code>thermo_pw</code>:</p>
<p align="justify">
8. X. Gong, Ab initio thermoelasticity of crystals at extremes,
<a href="https://iris.sissa.it/handle/20.500.11767/143090">PhD Thesis</a>.</p>
<p align="justify">
7. B. Thakur, X. Gong, and A. Dal Corso,
Thermodynamic properties of fcc lead: A scalar and fully 
relativistic first principle study,
<a href="https://doi.org/10.1016/j.commatsci.2025.113677">
Comp. Materials Science <b>249</b>, 113677 (2025)</a>.</p>
<p align="justify">
6. C. Malica and A. Dal Corso,
Finite-temperature atomic relaxations: Effect on the temperature-dependent C<sub>44</sub> elastic constants of Si and BAs,
<a href="https://doi.org/10.1063/5.0093376">
Jour. Chem. Phys. <B>156</B>, 194111 (2022)</a>.</p> 
<p align="justify">
5. C. Malica,
From ab-initio thermodynamics to quasi-harmonic thermoelastic properties 
of crystals: A new workflow and selected applications,
<a href="https://iris.sissa.it/retrieve/handle/20.500.11767/125489/148394/Cristiano_Malica_Thesis.pdf">PhD thesis</a>.</p>
<p align="justify">
4. A. Urru,
Lattice dynamics with Fully Relativistic Pseudopotentials for magnetic systems,
with selected applications,
<a href="https://iris.sissa.it/handle/20.500.11767/115671#.X8uStKYo-cM">PhD thesis</a>.</p>
<p align="justify">
3. A. Urru and A. Dal Corso,
Lattice dynamics effects on the magnetocrystalline anisotropy
energy: application to MnBi,
<a href="https://journals.aps.org/prb/abstract/10.1103/PhysRevB.102.115126">
Phys. Rev. B <B>102</B>, 115126 (2020)</a>.</p>
<p align="justify">
2. C. Malica and A. Dal Corso,
Temperature dependent elastic constants and thermodynamic properties 
of BAs: an ab-initio investigation, 
<a href="https://aip.scitation.org/doi/10.1063/5.0011111">
Jour. of Applied Phys. <B>127</B>, 245103 (2020)</a>.</p>
<p align="justify">
1. S. Poncé, D. Jena, and F. Giustino,
Hole mobility of strained GaN from first principles,
<a href="https://journals.aps.org/prb/abstract/10.1103/PhysRevB.100.085204">
Phys. Rev. B <B>100</B>, 085204 (2019)</a>.</p>
<p align="justify">
See also the presentation given at the Quantum-ESPRESSO developers meeting 2017:</p>
<br>
<p align="justify">
<a href="https://people.sissa.it/~dalcorso/thermo_pw_2017.pdf">Thermo_pw_2017.pdf</a></p>
<p align="justify">
and at the Quantum-ESPRESSO developers meeting 2018:</p>
<br>
<p align="justify">
<a href="https://people.sissa.it/~dalcorso/thermo_pw_2018.pdf">Thermo_pw_2018.pdf</a></p>

<p align="justify">
The latest developments of the <code>thermo_pw</code> software can be
followed <a href="https://github.com/dalcorso/thermo_pw/commits/master">here</a>.</p>

**Troubleshooting <code>thermo_pw</code>:**

<p align="justify">If you encounter issues compiling or running <code>thermo_pw</code>, or suspect you've found a bug, please follow these steps:</p>

<p align="justify">
Consult the Quick-Help Page: Refer to the quick-help <a href="https://dalcorso.github.io/thermo_pw/thermo_pw_help.html"> page</a> for potential solutions.</p>

<p align="justify">
Apply Patches: Ensure you have applied all available patches to the software.</p>

<p align="justify">
Seek Further Assistance: If the problem persists, please post details to the <a href="mailto:thermo_pw-forum@lists.quantum-espresso.org">thermo_pw-forum mailing list</a> or email me at <a href="mailto:dalcorso .at. sissa.it">dalcorso .at. sissa.it</a>. You can subscribe to the thermo_pw-forum mailing list by clicking <a href="https://lists.quantum-espresso.org/mailman/listinfo/thermo_pw-forum">here</a>.</p>

<p align="justify">Important Note: Please do not send me questions regarding the input format for <code>pw.x</code>.</p>

<p align="justify">Errors such as:</p>

    tmp_dir cannot be opened
    error in namelist

<p align="justify">are often self-explanatory. The error message itself usually indicates the problem. You can find potential solutions in the FAQ (questions 23 and 24) located <a href="https://dalcorso.github.io/thermo_pw/thermo_pw_help.html">here.</a> If these suggestions do not resolve your issue, I am unlikely to have further specific guidance.</p>

<p aling="justify"> For additional help, you can also consult the Quantum ESPRESSO user guide, post your question to the users mailing list at the <code>users@lists.quantum-espresso.org</code>, or search for similar issues in the examples directories.</p>
<br>
**Thermo_pw downloads**:
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.2.1.1.tar.gz">
thermo_pw.2.1.1.tar.gz</a>  (released 13-10-2025) compatible with QE-7.5
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.2.1.0.tar.gz">
thermo_pw.2.1.0.tar.gz</a>  (released 24-09-2025) compatible with QE-7.4.1
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.2.0.3.tar.gz">
thermo_pw.2.0.3.tar.gz</a>  (released 23-06-2025) compatible with QE-7.4.1
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.2.0.2.tar.gz">
thermo_pw.2.0.2.tar.gz</a>  (released 20-06-2025) compatible with QE-7.4.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.2.0.1.tar.gz">
thermo_pw.2.0.1.tar.gz</a>  (released 15-04-2025) compatible with QE-7.3.1.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.2.0.0.tar.gz">
thermo_pw.2.0.0.tar.gz</a>  (released 24-09-2024) compatible with QE-7.3.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.9.1.tar.gz">
thermo_pw.1.9.1.tar.gz</a>  (released 14-02-2024) compatible with QE-7.3.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.9.0.tar.gz">
thermo_pw.1.9.0.tar.gz</a>  (released 26-01-2024) compatible with QE-7.2.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.8.1.tar.gz">
thermo_pw.1.8.1.tar.gz</a>  (released 05-05-2023) compatible with QE-7.2.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.8.0.tar.gz">
thermo_pw.1.8.0.tar.gz</a>  (released 26-04-2023) compatible with QE-7.1.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.7.1.tar.gz">
thermo_pw.1.7.1.tar.gz</a>  (released 05-07-2022) compatible with QE-7.1.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.7.0.tar.gz">
thermo_pw.1.7.0.tar.gz</a>  (released 05-07-2022) compatible with QE-7.0.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.6.1.tar.gz">
thermo_pw.1.6.1.tar.gz</a>  (released 10-01-2022) compatible with QE-7.0.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.6.0.tar.gz">
thermo_pw.1.6.0.tar.gz</a>  (released 27-12-2021) compatible with QE-6.8.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.5.1.tar.gz">
thermo_pw.1.5.1.tar.gz</a>  (released 22-07-2021) compatible with QE-6.8.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.5.0.tar.gz">
thermo_pw.1.5.0.tar.gz</a>  (released 19-07-2021) compatible with QE-6.7.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.4.1.tar.gz">
thermo_pw.1.4.1.tar.gz</a>  (released 29-12-2020) compatible with QE-6.7.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.4.0.tar.gz">
thermo_pw.1.4.0.tar.gz</a>  (released 22-12-2020) compatible with QE-6.6.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.3.2.tar.gz">
thermo_pw.1.3.2.tar.gz</a>  (released 17-8-2020) compatible with QE-6.6.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.3.1.tar.gz">
thermo_pw.1.3.1.tar.gz</a>  (released 13-8-2020) compatible with QE-6.6.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.3.0.tar.gz">
thermo_pw.1.3.0.tar.gz</a>  (released 12-8-2020) compatible with QE-6.5.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.2.1.tar.gz">
thermo_pw.1.2.1.tar.gz</a>  (released 23-1-2020) compatible with QE-6.5.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.2.0.tar.gz">
thermo_pw.1.2.0.tar.gz</a>  (released 28-12-2019) compatible with QE-6.4.1.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.1.1.tar.gz">
thermo_pw.1.1.1.tar.gz</a>  (released 16-04-2019) compatible with QE-6.4.1.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.1.0.tar.gz">
thermo_pw.1.1.0.tar.gz</a>  (released 16-04-2019) compatible with QE-6.4.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.0.9.tar.gz">
thermo_pw.1.0.9.tar.gz</a>  (released 06-03-2019) compatible with QE-6.3.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.1.0.0.tar.gz">
thermo_pw.1.0.0.tar.gz</a>  (released 17-07-2018) compatible with QE-6.3.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw-0.9.9.tar.gz">
thermo_pw-0.9.9.tar.gz</a>  (released 05-07-2018) compatible with QE-6.2.1.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw-0.9.0.tar.gz">
thermo_pw-0.9.0.tar.gz</a>  (released 20-12-2017) compatible with QE-6.2.1.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw-0.8.0.tgz">
thermo_pw-0.8.0.tar.gz</a>  (released 24-10-2017) compatible with QE-6.2.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw-0.8.0-beta.tgz">
thermo_pw-0.8.0-beta.tar.gz</a>  (released 31-08-2017) compatible with QE-6.2-beta.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.0.7.9.tgz">
thermo_pw.0.7.9.tgz</a>  (released 06-07-2017) compatible with QE-6.1.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.0.7.0.tgz">
thermo_pw.0.7.0.tgz</a>  (released 18-03-2017) compatible with QE-6.1.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.0.6.0.tgz">
thermo_pw.0.6.0.tgz</a>  (released 05-10-2016) compatible with QE-6.0.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.0.5.0.tar.gz">
thermo_pw.0.5.0.tar.gz</a>  (released 26-04-2016) compatible with QE-5.4.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.0.4.0.tar.gz">
thermo_pw.0.4.0.tar.gz</a>  (released 23-01-2016) compatible with QE-5.3.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.0.3.0.tar.gz">
thermo_pw.0.3.0.tar.gz</a>  (released 23-06-2015) compatible with QE-5.2.0 and QE-5.2.1.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.0.2.0.tar.gz">
thermo_pw.0.2.0.tar.gz</a>   (released 13-03-2015) compatible with QE-5.1.2.
<br>
* <a href="http://people.sissa.it/%7Edalcorso/thermo_pw/thermo_pw.0.1.0.tar.gz">
thermo_pw.0.1.0.tar.gz</a>   (released 28-11-2014) compatible with QE-5.1.1.
<br>
<p align="justify">
Please note that the <code>thermo_pw</code> and <code>QE</code> versions must be carefully matched as specified above. Mismatched versions will result in a compilation error.</p>
